//=============================================================================
// Terrorist.
//=============================================================================
class BorderlandsAnimal extends Animal;

#exec TEXTURE IMPORT FILE="Textures\Skag.pcx" NAME="SkagTex1" GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\SpitterSkag.pcx" NAME="SpitterSkag" GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\BadassSkag.pcx" NAME="BadassSkag" GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\CorrosiveSkag.pcx" NAME="CorrosiveSkag" GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\FlamingSkag.pcx" NAME="FlamingSkag" GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\ShockSkag.pcx" NAME="ShockSkag" GROUP="Skins" MIPS=Off

var int MaxHealthMark;
var int LevelStrength;

var BLHealthSprite HealthSprite;
var BLLevelSprite LevelSprite;

var bool bHealthSet;
var string HitBoxType, ElementalType;

//================
//Skag Variables
//================

var float ChargeTime, ChargeDur, ChargeLeft, ChargeCooldown;

var float ChargePeak;
var bool bCharging;

function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 if (Mesh == LODMesh'Doberman')
 {
  ChargeDur = 1.0;
  ChargePeak = 0.835 * CollisionHeight;
 }
}

function StartCharge()
{
 /*if (!bCharging && ChargeCooldown <= 0)
 {
  SetPhysics(PHYS_Falling);
  SetState('Charging');
 }*/
}

//============================
//----------------------------
//CHARGE ATTACK START
//----------------------------
//============================

function Bump(Actor Other)
{
	local DeusExWeapon dxWeapon;
	local DeusExPlayer dxPlayer;
	local float        damage;

	Super.Bump(Other);

	if (IsInState('Attacking') && (Other != None) && (Other == Enemy))
	{
		// damage both of the player's legs if the karkian "charges"
		// just use Shot damage since we don't have a special damage type for charged
		// impart a lot of momentum, also
		if (VSize(Velocity) > 100)
		{
			dxWeapon = DeusExWeapon(Weapon);
			if ((dxWeapon != None) && dxWeapon.IsA('WeaponSkagCharge') && (FireTimer <= 0))
			{
				FireTimer = DeusExWeapon(Weapon).AIFireDelay;
				damage = VSize(Velocity) / 5;
				Other.TakeDamage(damage, Self, Other.Location+vect(1,1,-1), 100*Velocity, 'Shot');
				Other.TakeDamage(damage, Self, Other.Location+vect(-1,-1,-1), 100*Velocity, 'Shot');
				dxPlayer = DeusExPlayer(Other);
				if (dxPlayer != None)
					dxPlayer.ShakeView(0.15 + 0.002*damage*2, damage*30*2, 0.3*damage*2);
			}
			if ((dxWeapon != None) && dxWeapon.IsA('WeaponFireSkagCharge') && (FireTimer <= 0))
			{
				FireTimer = DeusExWeapon(Weapon).AIFireDelay;
				damage = VSize(Velocity) / 10;
				Other.TakeDamage(damage, Self, Other.Location+vect(1,1,-1), 100*Velocity, 'Flamed');
				Other.TakeDamage(damage, Self, Other.Location+vect(-1,-1,-1), 100*Velocity, 'Flamed');
				dxPlayer = DeusExPlayer(Other);
				if (dxPlayer != None)
					dxPlayer.ShakeView(0.15 + 0.002*damage*2, damage*30*2, 0.3*damage*2);
			}
		}
	}
}

/*state Charging
{
 function Bump(Actor Other)
 {
	local DeusExWeapon dxWeapon;
	local DeusExPlayer dxPlayer;
	local float        damage;

	Super.Bump(Other);

	if (IsInState('Attacking') && (Other != None) && (Other == Enemy))
	{
		// damage both of the player's legs if the karkian "charges"
		// just use Shot damage since we don't have a special damage type for charged
		// impart a lot of momentum, also
		if (VSize(Velocity) > 100)
		{
			dxWeapon = DeusExWeapon(Weapon);
			if ((dxWeapon != None) && dxWeapon.IsA('WeaponSkagCharge'))// && (FireTimer <= 0))
			{
				FireTimer = DeusExWeapon(Weapon).AIFireDelay;
				damage = VSize(Velocity) / 5;
				Other.TakeDamage(damage, Self, Other.Location+vect(1,1,-1), 100*Velocity, 'Shot');
				Other.TakeDamage(damage, Self, Other.Location+vect(-1,-1,-1), 100*Velocity, 'Shot');
				dxPlayer = DeusExPlayer(Other);
				if (dxPlayer != None)
					dxPlayer.ShakeView(0.15 + 0.002*damage*2, damage*30*2, 0.3*damage*2);
			}
		}
	}
 }
 /*function Tick(float D)
 {
  Super.Tick(D);
  
  SetLocation(Location + ((vect(1,0,0) >> Rotation) * CollisionRadius * 3 / ChargeDur) + (vect(0,0,1) * ChargePeak * ChargeTime * 2));
  
  
  ChargeTime -= D;
  ChargeLeft += D;
  
  if (ChargeLeft > ChargeDur) SetState('Attacking');
  
 }*/
 
 function BeginState()
 {
  Super.BeginState();
  
  BroadcastMessage("Start");
  
  ChargeTime = ChargeDur / 2;
  ChargeLeft = 0;
  bCharging = True;
 }
 function EndState()
 {
  Super.EndState();

  BroadcastMessage("End");
  
  ChargeTime = 0;
  ChargeLeft = 0;
  ChargeCooldown = 3;
  bCharging = False;
 }
 function StartCharge()
 {
 }
}*/

//============================
//++++++++++++++++++++++++++++
//CHARGE ATTACK END
//++++++++++++++++++++++++++++
//============================

function ExtinguishFire()
{
 if (ElementalType ~= "Flamed") return;
 
 Super.ExtinguishFire();
}

function Tick(float deltaTime)
{
	local float        dropPeriod;
	local float        adjustedRate;
	local DeusExPlayer player;
	local name         stateName;
	local vector       loc;
	local bool         bDoLowPriority;
	local bool         bCheckOther;
	local bool         bCheckPlayer;

	local Actor  curFood;
	local int    lastIndex;
	local float  dist;
	local vector tempVect;

	if (ChargeCooldown > 0)
	{
	 ChargeCooldown -= DeltaTime;
	}

	player = DeusExPlayer(GetPlayerPawn());

	bDoLowPriority = true;
	bCheckPlayer   = true;
	bCheckOther    = true;
	if (bTickVisibleOnly)
	{
		if (DistanceFromPlayer > 1200)
			bDoLowPriority = false;
		if (DistanceFromPlayer > 2500)
			bCheckPlayer = false;
		if ((DistanceFromPlayer > 600) && (LastRendered() >= 5.0))
			bCheckOther = false;
	}

/*
	if (bDisappear && (InStasis() || (LastRendered() > 5.0)))
	{
		Destroy();
		return;
	}

	if (PrePivotTime > 0)
	{
		if (deltaTime < PrePivotTime)
		{
			PrePivot = PrePivot + (DesiredPrePivot-PrePivot)*deltaTime/PrePivotTime;
			PrePivotTime -= deltaTime;
		}
		else
		{
			PrePivot = DesiredPrePivot;
			PrePivotTime = 0;
		}
	}

	if (bDoLowPriority)
		Super(Pawn).Tick(deltaTime);

	UpdateAgitation(deltaTime);
	UpdateFear(deltaTime);

	AlarmTimer -= deltaTime;
	if (AlarmTimer < 0)
		AlarmTimer = 0;

	if (Weapon != None)
		WeaponTimer += deltaTime;
	else if (WeaponTimer != 0)
		WeaponTimer = 0;

	if ((ReloadTimer > 0) && (Weapon != None))
		ReloadTimer -= deltaTime;
	else
		ReloadTimer = 0;

	if (AvoidWallTimer > 0)
	{
		AvoidWallTimer -= deltaTime;
		if (AvoidWallTimer < 0)
			AvoidWallTimer = 0;
	}

	if (AvoidBumpTimer > 0)
	{
		AvoidBumpTimer -= deltaTime;
		if (AvoidBumpTimer < 0)
			AvoidBumpTimer = 0;
	}

	if (CloakEMPTimer > 0)
	{
		CloakEMPTimer -= deltaTime;
		if (CloakEMPTimer < 0)
			CloakEMPTimer = 0;
	}

	if (TakeHitTimer > 0)
	{
		TakeHitTimer -= deltaTime;
		if (TakeHitTimer < 0)
			TakeHitTimer = 0;
	}

	if (CarcassCheckTimer > 0)
	{
		CarcassCheckTimer -= deltaTime;
		if (CarcassCheckTimer < 0)
			CarcassCheckTimer = 0;
	}

	if (PotentialEnemyTimer > 0)
	{
		PotentialEnemyTimer -= deltaTime;
		if (PotentialEnemyTimer <= 0)
		{
			PotentialEnemyTimer    = 0;
			PotentialEnemyAlliance = '';
		}
	}

	if (BeamCheckTimer > 0)
	{
		BeamCheckTimer -= deltaTime;
		if (BeamCheckTimer < 0)
			BeamCheckTimer = 0;
	}

	if (FutzTimer > 0)
	{
		FutzTimer -= deltaTime;
		if (FutzTimer < 0)
			FutzTimer = 0;
	}

	if (PlayerAgitationTimer > 0)
	{
		PlayerAgitationTimer -= deltaTime;
		if (PlayerAgitationTimer < 0)
			PlayerAgitationTimer = 0;
	}

	if (DistressTimer >= 0)
	{
		DistressTimer += deltaTime;
		if (DistressTimer > FearSustainTime)
			DistressTimer = -1;
	}

	if (bHasCloak)
		EnableCloak(Health <= CloakThreshold);

	if (bAdvancedTactics)
	{
		if ((Acceleration == vect(0,0,0)) || (Physics != PHYS_Walking) ||
		    (TurnDirection == TURNING_None))
		{
			bAdvancedTactics = false;
			if (TurnDirection != TURNING_None)
				MoveTimer -= 4.0;
			ActorAvoiding    = None;
			NextDirection    = TURNING_None;
			TurnDirection    = TURNING_None;
			bClearedObstacle = true;
			ObstacleTimer    = 0;
		}
	}

	if (bOnFire && ElementalType != "Flamed")
	{
		burnTimer += deltaTime;
		if (burnTimer >= BurnPeriod)
			ExtinguishFire();
	}

	if (bDoLowPriority)
	{
		if ((bleedRate > 0) && bCanBleed)
		{
			adjustedRate = (1.0-FClamp(bleedRate, 0.0, 1.0))*1.0+0.1;  // max 10 drops per second
			dropPeriod = adjustedRate / FClamp(VSize(Velocity)/512.0, 0.05, 1.0);
			dropCounter += deltaTime;
			while (dropCounter >= dropPeriod)
			{
				SpurtBlood();
				dropCounter -= dropPeriod;
			}
			bleedRate -= deltaTime/clotPeriod;
		}
		if (bleedRate <= 0)
		{
			dropCounter = 0;
			bleedRate   = 0;
		}
	}
*/

	if (bStandInterpolation)
		UpdateStanding(deltaTime);

	// this is UGLY!


	//WCCC - coincidentally, its un-needed by borderlands.
	/*if (bOnFire && (health > 0))
	{
		stateName = GetStateName();
		if ((stateName != 'Burning') && (stateName != 'TakingHit') && (stateName != 'RubbingEyes'))
			GotoState('Burning');
	}*/
	else
	{
		if (bDoLowPriority)
		{
			// Don't allow radius-based convos to interupt other conversations!
			if ((player != None) && (GetStateName() != 'Conversation') && (GetStateName() != 'FirstPersonConversation'))
				player.StartConversation(Self, IM_Radius);
		}

		if (CheckEnemyPresence(deltaTime, bCheckPlayer, bCheckOther))
			HandleEnemy();
		else
		{
			CheckBeamPresence(deltaTime);
			if (bDoLowPriority || LastRendered() < 5.0)
				CheckCarcassPresence(deltaTime);  // hacky -- may change state!
		}
	}

	// Randomly spawn an air bubble every 0.2 seconds if we're underwater
	if (HeadRegion.Zone.bWaterZone && bSpawnBubbles && bDoLowPriority)
	{
		swimBubbleTimer += deltaTime;
		if (swimBubbleTimer >= 0.2)
		{
			swimBubbleTimer = 0;
			if (FRand() < 0.4)
			{
				loc = Location + VRand() * 4;
				loc.Z += CollisionHeight * 0.9;
				Spawn(class'AirBubble', Self,, loc);
			}
		}
	}

	// Handle poison damage
	UpdatePoison(deltaTime);

	if (checkAggTimer > 0)
	{
		checkAggTimer -= DeltaTime;
		if (checkAggTimer < 0)
			checkAggTimer = 0;
	}

	if (aggressiveTimer > 0)
	{
		aggressiveTimer -= DeltaTime;
		if (aggressiveTimer < 0)
			aggressiveTimer = 0;
	}

	if ((FoodClass != None) && InterestedInFood())
	{
		FoodTimer += DeltaTime;
		if (FoodTimer > 0.5)
		{
			FoodTimer = 0;
			lastIndex = FoodIndex;
			foreach CycleActors(FoodClass, curFood, FoodIndex)
			{
				if (IsValidFood(curFood))
				{
					dist = VSize(curFood.Location - Location);
					if ((dist < 400) || ((dist < 800) && (AICanSee(curFood, , false, true, false, false) > 0.0)))
					{
						if ((BestFood == None) || (dist < BestDist))
						{
							if (GetFeedSpot(curFood, tempVect))
							{
								BestDist  = dist;
								BestFood  = curFood;
								FoodIndex = 0;
							}
							break;
						}
					}
				}
			}
			if (lastIndex >= FoodIndex)  // have we cycled through all actors?
			{
				if (BestFood != None)
				{
					if (bBefriendFoodGiver && (BestFood.Instigator != None))
						DecreaseAgitation(BestFood.Instigator, 2);
					Food = BestFood;
					SetState('Eating');
				}
				BestFood = None;
			}
		}
	}
	else
		FoodTimer = 0;
}

function ApplyHealthLevel()
{
 local int i, Result;
 local float F;
 
 if (bHealthSet) return;
 
 if (LevelStrength > 50) LevelStrength = 50;
 
 i = MaxHealthMark;
 f = float(LevelStrength) / 2;
 
 Result = i * f;
 
 if (Result < 25) Result = 10;
 
 BeefHealth(Result);
}

function BeefHealth(int i)
{
 if (bHealthSet) return;
 
 MaxHealthMark = i;
 Health = i;
 
 bHealthSet = True;
 
 //BroadcastMessage("Health Buffed To "$Health$"!");
}

function float ModifyDamage(int Damage, Pawn instigatedBy, Vector hitLocation,
                            Vector offset, Name damageType)
{
	local int   actualDamage;
	local float headOffsetZ, headOffsetY, armOffset;

	/*if (InstigatedBy.IsA('DeusExPlayer'))
	{
	 if (DeusExPlayer(InstigatedBy).InHand.IsA('WeaponCrowbar'))
	 {
	  BeefHealth();
	 }
	 
	 //InformMutator();
	}*/

	actualDamage = Damage;

	// calculate our hit extents
	headOffsetZ = CollisionHeight * 0.7;
	headOffsetY = CollisionRadius * 0.3;
	armOffset   = CollisionRadius * 0.35;

	// if the pawn is stunned, damage is 4X
	if (bStunned)
		actualDamage *= 4;

	// if the pawn is hit from behind at point-blank range, he is killed instantly
	else if (offset.x < 0)
		if ((instigatedBy != None) && (VSize(instigatedBy.Location - Location) < 64))
			actualDamage  *= 10;

	actualDamage = Level.Game.ReduceDamage(actualDamage, DamageType, self, instigatedBy);

	if (ReducedDamageType == 'All') //God mode
		actualDamage = 0;
	else if (Inventory != None) //then check if carrying armor
		actualDamage = Inventory.ReduceDamage(actualDamage, DamageType, HitLocation);

	// gas, EMP and nanovirus do no damage
	if (damageType == 'TearGas' || damageType == 'EMP' || damageType == 'NanoVirus')
		actualDamage = 0;

	if (damageType == 'Acid') actualDamage *= (MaxHealthMark / 100);
	if (String(DamageType) ~= ElementalType) actualDamage = 0;

	return actualDamage;

}

function GenerateTotalHealth()
{
}

function UpdateFire()
{
 local int Dam;
	
	Dam = (250 - MaxHealthMark / LevelStrength) / 10;

	if (Dam < 0 || ElementalType ~= "Flamed") Dam = 0;

	if (Dam <= 0) return;

	// continually burn and do damage
	Health -= Dam * LevelStrength / 10;
	GenerateTotalHealth();
	if (Health <= 0)
	{
		TakeDamage(10, FirstPlayer(), Location, vect(0,0,0), 'Burned');
		ExtinguishFire();
	}
	UpdateHealthSprite();
	SpawnDamageNumbers(Dam, True, False);
}

function EHitLocation HandleDamage(int actualDamage, Vector hitLocation, Vector offset, name damageType)
{
	local EHitLocation hitPos;
	local float        headOffsetZ, headOffsetY, armOffset, DogHeadOffset;

	local int TotalDamage;
	local bool bCrit, bReduced;

	// calculate our hit extents
	headOffsetZ = CollisionHeight * 0.7;
	headOffsetY = CollisionRadius * 0.3;
	armOffset   = CollisionRadius * 0.35;

	//dog scale = 58.5
	//dog head scale = 14
	//dog scale percentage = 76.068 %
        //dog radius percentage = 38.034 %

	hitPos = HITLOC_None;

	DogHeadOffset = CollisionRadius * 0.61966;

	if (HitBoxType ~= "Human")
	{

	if (actualDamage > 0)
	{
		if (offset.z > headOffsetZ)		// head
		{
			// narrow the head region
			if ((Abs(offset.x) < headOffsetY) || (Abs(offset.y) < headOffsetY))
			{
				// don't allow headshots with stunning weapons
				if ((damageType == 'Stunned') || (damageType == 'KnockedOut'))
					TotalDamage = 0;
				else
				{
					bCrit = True;
					TotalDamage = ActualDamage * 2;
				}
				if (offset.x < 0.0)
					hitPos = HITLOC_HeadBack;
				else
					hitPos = HITLOC_HeadFront;
			}
			else  // sides of head treated as torso
			{
				TotalDamage = ActualDamage;
				
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
			}
		}
		else						// arms and torso
		{
				TotalDamage = ActualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
		}
	}

	}
	if (HitBoxType ~= "Skag")
	{

	if (actualDamage > 0)
	{
		if (offset.x > (vect(1,0,0) >> Rotation * DogHeadOffset).X && Offset.Z > (vect(0,0,1) * CollisionHeight / 2 ).Z)		// head
		{
				bCrit = True;
				TotalDamage = ActualDamage * 2;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
		}
		else if (Offset.Z > (vect(0,0,1) * CollisionHeight / 2 ).Z)					// arms and torso
		{
				bReduced = True;

				TotalDamage = ActualDamage / 2;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
		}
		else					// arms and torso
		{
				TotalDamage = ActualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
		}
	}

	}
	if (HitBoxType ~= "WeakerSkag")
	{

	if (actualDamage > 0)
	{
		if (offset.x > (vect(1,0,0) >> Rotation * DogHeadOffset).X && Offset.Z > (vect(0,0,1) * CollisionHeight / 2 ).Z)		// head
		{
				bCrit = True;
				TotalDamage = ActualDamage * 2;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
		}
		else if (Offset.Z > (vect(0,0,1) * CollisionHeight / 2 ).Z)					// arms and torso
		{
				bReduced = True;

				TotalDamage = ActualDamage / 1.5;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
		}
		else					// arms and torso
		{
				TotalDamage = ActualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
		}
	}

	}
	if (HitBoxType ~= "TougherSkag")
	{

	if (actualDamage > 0)
	{
		if (offset.x > (vect(1,0,0) >> Rotation * DogHeadOffset).X && Offset.Z > (vect(0,0,1) * CollisionHeight / 2 ).Z )		// head
		{
				bCrit = True;
				TotalDamage = ActualDamage * 2;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
		}
		else if (Offset.Z > (vect(0,0,1) * CollisionHeight / 2 ).Z)					// arms and torso
		{
				bReduced = True;

				TotalDamage = ActualDamage / 3;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
		}
		else					// arms and torso
		{
				TotalDamage = ActualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
		}
	}

	}


	if (TotalDamage > 0) SpawnDamageNumbers(TotalDamage, bCrit, bReduced);

	Health -= TotalDamage;

	GenerateTotalHealth();


	//InformMutator();
	
	UpdateHealthSprite();
	
	return hitPos;
}

function SpawnDamageNumbers(int Dam, bool bCrit, bool bReduced)
{
 local String S, CurS, Color;
 local int i, j, k, l, Length;
 
 S = String(Dam);
 
 if (Dam > 9999) Dam = 9999;
 
 Length = Len(S);
 
 if (Length == 1)
 {
  i = Dam;
 }
 if (Length == 2)
 {
  j = int( LeftTrim(S, 1) );
  i = int( RightTrim(S, 1) );
 }
 if (Length == 3)
 {
  k = int( LeftTrim(S, 1) );
  j = int( MidTrim(S, 1, 1) );
  i = int( RightTrim(S, 1) );
 }
 if (Length == 4)
 {
  l = int( LeftTrim(S, 1) );
  j = int( MidTrim(S, 2, 1) );
  k = int( MidTrim(S, 1, 1) );
  i = int( RightTrim(S, 1) );
 }
 
 if (bCrit) Color = "Red";
 if (bReduced && !bCrit) Color = "Gray";
 if (!bReduced && !bCrit) Color = "White";
 
 SpawnNumbers(i, j, k, l, Color, Len(S));
}

function DeusExPlayer FirstPlayer()
{
 local DeusExPlayer Play;
 
 forEach allActors(class'DeusExPlayer', Play)
 {
  return Play;
 }
}



final function string RightTrim(String A, int B)
{
 local string S, s2;
 local string n;
 
 s = A;
 s2 = Right(s, B);
 
 n = s2;
 
 return n;
}

final function string MidTrim(string A, int B, optional int C)
{
 local string S, s2;
 local string n;
 
 s = A;
 s2 = Mid(s, B, C);
 
 n = s2;
 
 return n;
}

final function string LeftTrim(string A, int B)
{
 local string S, s2;
 local string n;
 
 s = A;
 s2 = Left(s, B);
 
 n = s2;
 
 return n;
}



function SpawnNumbers(int i, int j, int k, int l, string Color, int Length)
{
 local BLNumberSprite N;
 local Vector V, O;
 
 //BroadcastMessage(Length);
 
 //BroadcastMessage(i$j$k$l);
 
 //if (i == 0) i = 1;
 
 V = (vect(0,0,1) * CollisionHeight * 1.2) + ((vect(0,1,0) >> FirstPlayer().Rotation) * Rand(10)) + (vect(0,0,1) * Rand(10));
 
 O = vect(0,-4,0) >> FirstPlayer().Rotation;
 
 N = Spawn(class'BLNumberSprite', Self,,Location + V + O);
 N.Color = Color;
 N.Number = i;
 N.UpdateTexture();
 
 if (Length > 1)
 {
  N = Spawn(class'BLNumberSprite', Self,,Location + V + (O * 2));
  N.Color = Color;
  N.Number = j;
  N.UpdateTexture();
 }
 
 if (Length > 2)
 {
  N = Spawn(class'BLNumberSprite', Self,,Location + V + (O * 3));
  N.Color = Color;
  N.Number = k;
  N.UpdateTexture();
 }
 
 if (Length > 3)
 {
  N = Spawn(class'BLNumberSprite', Self,,Location + V + (O * 4));
  N.Color = Color;
  N.Number = l;
  N.UpdateTexture();
 }
}

function UpdateHealthSprite()
{
 if (HealthSprite == None) SpawnHealthSprite();
 
 HealthSprite.UpdateTexture(Health, MaxHealthMark);
}

function SpawnHealthSprite()
{
 HealthSprite = Spawn(class'BLHealthSprite', Self);
 HealthSprite.SetTimer(0.02, True);

 LevelSprite = Spawn(class'BLLevelSprite', Self);
 LevelSprite.CurrentLevel = LevelStrength;
 LevelSprite.UpdateTexture();
 LevelSprite.SetTimer(0.02, True);
}

function TakeDamage(int D, Pawn Inst, vector H, vector M, name T)
{
 if (String(T) ~= ElementalType) D = 0;
 
 Super.TakeDamage(D, Inst, H, M, T);
}

defaultproperties
{
     MinHealth=0.000000
}
